//
//  PXIClassicToolPaletteView.m
//  PXIClassicView
//
//  Created by decaf on 1/16/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import "PXIClassicToolPaletteView.h"


@implementation PXIClassicToolPaletteView

- (id)initWithFrame:(NSRect)frame {
    self = [super initWithFrame:frame];
    if (self)
	{
		RegularToolBar = [NSImage imageNamed: @"ToolBar(Reg)"];
		FilledToolBar = [NSImage imageNamed: @"ToolBar(Filled)"];
		ToolBarSelectHiliteBox = [NSImage imageNamed: @"ToolBarSelectHilite"];
		ToolBarHoverHiliteBox = [NSImage imageNamed: @"ToolBarHoverHilite"];
		
		SelectCellX = 0;
		SelectCellY = 5;
		HoverCellX = -1;
		HoverCellY = -1;
	}
    return self;
}

- (void)viewDidMoveToWindow
{
	// We need this so we can get mouse tracking.
	myTrackingTag = [self addTrackingRect:[self bounds] owner:self userData:nil assumeInside:NO];	
}

- (void)viewWillMoveToWindow:(NSWindow*)newWindow
{
	[self removeTrackingRect:myTrackingTag];
}

- (void) mouseEntered:(NSEvent*)theEvent
{
	NSPoint clickPt = [self convertPoint:[theEvent locationInWindow] fromView:nil];

	while ( NSMouseInRect( clickPt, [self bounds], NO ) )
	{
		
		clickPt = ( [self convertPoint:[[self window] mouseLocationOutsideOfEventStream] fromView:nil] );

		int tX, tY;
	
		tX = ( clickPt.x );
		tY = ( clickPt.y );
	
		if ( tY > 190 )
		{
			tY = tY - 8;
		}
	
		HoverCellX = tX / 48;
		HoverCellY = tY / 38;
		
		if ( HoverCellY > 5 )
		{
			HoverCellY = 5;
		}
	
		if ( [[self window] nextEventMatchingMask:NSLeftMouseDownMask untilDate:[NSDate dateWithTimeIntervalSinceNow:0.01] inMode:NSEventTrackingRunLoopMode dequeue:YES] != nil )
		{
			SelectCellX = HoverCellX;
			SelectCellY = HoverCellY;

			[self setNeedsDisplay:YES];

			if ( [[self window] nextEventMatchingMask:NSLeftMouseDownMask untilDate:[NSDate dateWithTimeIntervalSinceNow:0.5] inMode:NSEventTrackingRunLoopMode dequeue:YES] != nil )
			{
				FilledState = ! FilledState;
			}
		}
		
		[self setNeedsDisplay:YES];

	}
	
	HoverCellY = -1;
	HoverCellX = -1;
}

+ (NSPoint) toolToPoint:(int)tool
{
	switch ( tool )
	{
		case 1:
			return NSMakePoint( 0, 5 );
			break;
		case 2:
			return NSMakePoint( 1, 5 );
			break;
		case 3:
			return NSMakePoint( 2, 5 );
			break;
		case 4:
			return NSMakePoint( 0, 4 );
			break;
		case 5:
			return NSMakePoint( 1, 4 );
			break;
		case 6:
			return NSMakePoint( 2, 4 );
			break;
		case 7:
			return NSMakePoint( 0, 3 );
			break;
		case 8:
			return NSMakePoint( 1, 3 );
			break;
		case 9:
			return NSMakePoint( 2, 3 );
			break;
		case 10:
			return NSMakePoint( 0, 2 );
			break;
		case 11:
			return NSMakePoint( 1, 2 );
			break;
		case 12:
			return NSMakePoint( 2, 2 );
			break;
		case 13:
			return NSMakePoint( 0, 1 );
			break;
		case 14:
			return NSMakePoint( 1, 1 );
			break;
		case 15:
			return NSMakePoint( 2, 1 );
			break;
		case 16:
			return NSMakePoint( 0, 0 );
			break;
		case 17:
			return NSMakePoint( 1, 0 );
			break;
		case 18:
			return NSMakePoint( 2, 0 );
			break;
	}
}

+ (int) pointToTool:(NSPoint)thePoint
{
	return ( ( 5 - ( thePoint.y ) ) * 3 ) + thePoint.x;
}

- (void) changeToolTo:(int)newTool
{
	NSPoint p = toolToPoint( newTool );
	SelectCellX = p.x;
	SelectCellY = p.y;
}

- (int) getTool
{
	return pointToTool( SelectCellX, SelectCellY );
}

- (void)drawRect:(NSRect)rect
{
	
	[ToolBarHoverHiliteBox compositeToPoint:NSMakePoint( HoverCellX * 48, HoverCellY * 38 + ( ( HoverCellY == 5 ) ? 8 : 0 ) ) operation:NSCompositeSourceOver ];
	[ToolBarSelectHiliteBox compositeToPoint:NSMakePoint( SelectCellX * 48, SelectCellY * 38 + ( ( SelectCellY == 5 ) ? 8 : 0 ) ) operation:NSCompositeSourceOver ];
	
	if ( FilledState )
	{
		[FilledToolBar compositeToPoint:NSMakePoint(0,0) operation:NSCompositeSourceOver];
	}
	else
	{
		[RegularToolBar compositeToPoint:NSMakePoint(0,0) operation:NSCompositeSourceOver];
	}
}

@end
